using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmGenerateTrwReport
	/// </summary>
	public class FrmGenerateTrwReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.PatientTransfusionReaction _patientTransfusionReaction;
		private BOL.TransfusionReactionWorkupReport _transfusionReactionWorkupReport;
		private Guid _orderedTestGuid;
		private Guid _patientTransfusionReactionGuid;
		private Common.PatientTransfusionPartialSaveId _partialSaveId;
		private System.Windows.Forms.Button btnClose;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.GroupBox grpImage;
        private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.CheckBox cbFinalizeTRW;
		private System.Windows.Forms.PrintDialog printDialog1;
		private System.Windows.Forms.Button btnSchedulePrint;
		private System.ComponentModel.IContainer components = null;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvTRWReport;
        private DataSet _dsReport = new DataSet();

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="orderedTestGuid"></param>
		/// <param name="patientTransfusionReactionGuid"></param>
		/// <param name="partialSaveId"></param>
		public FrmGenerateTrwReport(Guid orderedTestGuid, Guid patientTransfusionReactionGuid, Common.PatientTransfusionPartialSaveId partialSaveId)
		{
			this.LockController.LockFunction = Common.LockFunctions.UC078GenerateTrwReports;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this._orderedTestGuid = orderedTestGuid;
			this._patientTransfusionReactionGuid = patientTransfusionReactionGuid;
			this._transfusionReactionWorkupReport = new BOL.TransfusionReactionWorkupReport();
			this._transfusionReactionWorkupReport.PatientTransfusionReactionGuid = patientTransfusionReactionGuid;
			this._partialSaveId = partialSaveId;

			SetComponentProperties();

			LoadReport(false);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmGenerateTrwReport));
            this.btnClose = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picImage = new System.Windows.Forms.PictureBox();
            this.cbFinalizeTRW = new System.Windows.Forms.CheckBox();
            this.btnSchedulePrint = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.rvTRWReport = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 5;
            this.vbecsLogo1.Title = "Transfusion Reaction Workup Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 7;
            // 
            // btnClose
            // 
            this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnClose.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnClose.Location = new System.Drawing.Point(564, 448);
            this.btnClose.Name = "btnClose";
            this.btnClose.Size = new System.Drawing.Size(75, 23);
            this.btnClose.TabIndex = 4;
            this.btnClose.Text = "&Close";
            this.btnClose.Click += new System.EventHandler(this.CloseClick);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(436, 448);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(124, 23);
            this.btnPrint.TabIndex = 3;
            this.btnPrint.Text = "&Print Now";
            this.btnPrint.Click += new System.EventHandler(this.PrintClick);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picImage);
            this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 412);
            this.grpImage.TabIndex = 6;
            this.grpImage.TabStop = false;
            // 
            // picImage
            // 
            this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
            this.picImage.Location = new System.Drawing.Point(4, 12);
            this.picImage.Name = "picImage";
            this.picImage.Size = new System.Drawing.Size(45, 45);
            this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picImage.TabIndex = 0;
            this.picImage.TabStop = false;
            // 
            // cbFinalizeTRW
            // 
            this.cbFinalizeTRW.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.cbFinalizeTRW.Location = new System.Drawing.Point(60, 424);
            this.cbFinalizeTRW.Name = "cbFinalizeTRW";
            this.cbFinalizeTRW.Size = new System.Drawing.Size(276, 20);
            this.cbFinalizeTRW.TabIndex = 1;
            this.cbFinalizeTRW.Text = "&Finalize Transfusion Reaction Workup Report";
            this.cbFinalizeTRW.CheckedChanged += new System.EventHandler(this.FinalizeTRW);
            // 
            // btnSchedulePrint
            // 
            this.btnSchedulePrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSchedulePrint.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnSchedulePrint.Image = ((System.Drawing.Image)(resources.GetObject("btnSchedulePrint.Image")));
            this.btnSchedulePrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnSchedulePrint.Location = new System.Drawing.Point(308, 448);
            this.btnSchedulePrint.Name = "btnSchedulePrint";
            this.btnSchedulePrint.Size = new System.Drawing.Size(124, 23);
            this.btnSchedulePrint.TabIndex = 2;
            this.btnSchedulePrint.Text = "&Schedule Print";
            this.btnSchedulePrint.Click += new System.EventHandler(this.SchedulePrintClick);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // rvTRWReport
            // 
            this.rvTRWReport.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvTRWReport.Location = new System.Drawing.Point(60, 37);
            this.rvTRWReport.Name = "rvTRWReport";
            this.rvTRWReport.Size = new System.Drawing.Size(579, 381);
            this.rvTRWReport.TabIndex = 8;
            // 
            // FrmGenerateTrwReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnClose;
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.rvTRWReport);
            this.Controls.Add(this.btnSchedulePrint);
            this.Controls.Add(this.cbFinalizeTRW);
            this.Controls.Add(this.btnClose);
            this.Controls.Add(this.btnPrint);
            this.Controls.Add(this.grpImage);
            this.hlphelpChm.SetHelpKeyword(this, "Finalize_Print_TRW.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 450);
            this.Name = "FrmGenerateTrwReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Transfusion Reaction Workup Report";
            this.Load += new System.EventHandler(this.FrmGenerateTrwReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnClose, 0);
            this.Controls.SetChildIndex(this.cbFinalizeTRW, 0);
            this.Controls.SetChildIndex(this.btnSchedulePrint, 0);
            this.Controls.SetChildIndex(this.rvTRWReport, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC078.FrmGenerateTrwReport());
			//
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.PrintInternalReports))
			{
				this.cbFinalizeTRW.Enabled = (_partialSaveId != Common.PatientTransfusionPartialSaveId.ReportFinalized);
			}
			else
			{
				this.cbFinalizeTRW.Enabled = false;
			}
			//
			this.SetThisToolTip(this.btnClose,Common.StrRes.Tooltips.Common.Close());
			this.SetThisToolTip(this.btnPrint,Common.StrRes.Tooltips.Common.Print());
			this.SetThisToolTip(this.btnSchedulePrint,Common.StrRes.Tooltips.Common.SchedulePrint());
            BOL.VbecsReport.SetUpReportButtons(this.rvTRWReport);
        }

		private void LoadReport(bool refresh)
		{
            _dsReport = this._transfusionReactionWorkupReport.GetPatientTransfusionReactionReport();
#if DEBUG
            //_dsReport.Tables[0].WriteXml("e:\\temp\\TRWDataSet.xml", XmlWriteMode.WriteSchema);
            //_dsReport.Tables[1].WriteXml("e:\\temp\\TRWSymptomsDataSet.xml", XmlWriteMode.WriteSchema);
            //_dsReport.Tables[2].WriteXml("e:\\temp\\TRWImplicatedUnitsDataSet.xml", XmlWriteMode.WriteSchema);
            //_dsReport.Tables[3].WriteXml("e:\\temp\\TRWSerologicTestsDataSet.xml", XmlWriteMode.WriteSchema);
#endif

            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReport.Tables.Count > 0)
            {
                reportSourceMain.Name = "TRWDataSet";
                reportSourceMain.Value = _dsReport.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionWorkupReport.TransfusionReactionWorkupReport.rdlc");
            Stream streamSymptoms = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionWorkupReport.TRWSymptoms.rdlc");
            Stream streamTests = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionWorkupReport.TRWSerologicTests.rdlc");
            Stream streamUnits = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionWorkupReport.TRWImplicatedUnits.rdlc");
            
            this.rvTRWReport.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            this.rvTRWReport.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvTRWReport.LocalReport.DataSources.Add(reportSourceMain);
            this.rvTRWReport.LocalReport.LoadReportDefinition(stream);
            this.rvTRWReport.LocalReport.LoadSubreportDefinition("TRWSymptoms", streamSymptoms);
            this.rvTRWReport.LocalReport.LoadSubreportDefinition("TRWSerologicTests", streamTests);
            this.rvTRWReport.LocalReport.LoadSubreportDefinition("TRWImplicatedUnits", streamUnits);

            if (refresh)
            {
                Form frm = new FrmGenerateTrwReport(this._orderedTestGuid, this._patientTransfusionReactionGuid,
                                                    Common.PatientTransfusionPartialSaveId.ReportFinalized);
                frm.MdiParent = this.MdiParent;
                frm.Show();
                frm.Refresh();
                this.Close();
            }

		}

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "TRWSymptoms" || e.DataSourceNames[0].ToString() == "TRWSymptomsDataSet")
            {
                ReportDataSource reportSymptoms = new ReportDataSource();
                if (_dsReport.Tables.Count > 1)
                {
                    reportSymptoms.Name = "TRWSymptomsDataSet";
                    reportSymptoms.Value = _dsReport.Tables[1];
                }
                e.DataSources.Add(reportSymptoms);
            }
            else if (e.ReportPath == "TRWImplicatedUnits" || e.DataSourceNames[0].ToString() == "TRWImplicatedUnitsDataSet")
            {
                ReportDataSource reportImplicatedUnits = new ReportDataSource();
                if (_dsReport.Tables.Count > 2)
                {
                    reportImplicatedUnits.Name = "TRWImplicatedUnitsDataSet";
                    reportImplicatedUnits.Value = _dsReport.Tables[2];
                }
                e.DataSources.Add(reportImplicatedUnits);
            }
            else if (e.ReportPath == "TRWSerologicTests" || e.DataSourceNames[0].ToString() == "TRWSerologicTestsDataSet")
            {
                ReportDataSource reportSerologicTests = new ReportDataSource();
                if (_dsReport.Tables.Count > 3)
                {
                    reportSerologicTests.Name = "TRWSerologicTestsDataSet";
                    reportSerologicTests.Value = _dsReport.Tables[3];
                }
                e.DataSources.Add(reportSerologicTests);
            }
        }

		private void CloseClick(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void PrintClick(object sender, System.EventArgs e)
		{
            //CR 3416 CR 3449
            try
            {
                this.rvTRWReport.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

		private void FinalizeTRW(object sender, System.EventArgs e)
		{
			if (this.cbFinalizeTRW.Checked)
			{
				//
				//We must check that the Medical Director Name exists before opening the Finalize TRW dialog.
				BOL.Division dvsn = new BOL.Division(Common.LogonUser.LogonUserDivisionCode);
				if ((dvsn.MedicalDirectorName == null) || (dvsn.MedicalDirectorName.Trim().Length==0))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC078.MedicalDirectorUnknown());
					this.cbFinalizeTRW.Checked = false;
					return;
				}
				//Locking
				if (!this.SetLocks(this._patientTransfusionReactionGuid))
				{
					this.cbFinalizeTRW.Checked = false;
					return;
				}
				//
				this._patientTransfusionReaction = new BOL.PatientTransfusionReaction(this._orderedTestGuid);
				//
				DlgFinalizeTrwReport dlg = new DlgFinalizeTrwReport(this._patientTransfusionReaction);

                dlg.ShowDialogFromLockedParent(this, false);
				if (dlg.DialogResult == DialogResult.OK)
				{
					//refresh report, beacuse its been finalized now
					this.LoadReport(true);
					this.cbFinalizeTRW.Enabled = false;
				}
				this.cbFinalizeTRW.Checked = false;
			}
		}

		private void SchedulePrintClick(object sender, System.EventArgs e)
		{
			controls.DlgSchedulePrint dlg = new controls.DlgSchedulePrint("Transfusion Reaction Workup Report");

			dlg.ShowDialogFromLockedParent(this,false);
            if (dlg.DialogResult != DialogResult.OK)
			{
				return;
			}
			this._transfusionReactionWorkupReport.IsScheduled = true;
			this._transfusionReactionWorkupReport.PrintDate = dlg.PrintDate;
			this._transfusionReactionWorkupReport.PrinterName = dlg.PrinterName;
			this._transfusionReactionWorkupReport.Schedule();
			this.Close();
		}

        private void FrmGenerateTrwReport_Load(object sender, EventArgs e)
        {

            this.rvTRWReport.RefreshReport();
        }
	}
}

